unit mVimmICE;

interface

uses
  Winapi.Windows, Winapi.Messages, System.SysUtils, System.Variants, System.Classes, Vcl.Graphics,
  Vcl.Controls, Vcl.Forms, Vcl.Dialogs, mVImmBase, System.ImageList,
  Vcl.ImgList, Vcl.Buttons, Vcl.StdCtrls, Vcl.ExtCtrls, rvimm, orFn,
  Vcl.ComCtrls, Vcl.Menus, mVimmSelect;

type
  TfraIce = class(TfraParent)
    lstICE: TListView;
    mnuActions: TPopupMenu;
    Splitter1: TSplitter;
    memHist: TRichEdit;
    AddImmunization1: TMenuItem;
    ViewHistory1: TMenuItem;
    procedure addImmunization(Sender: TObject);
    procedure viewHistory(Sender: TObject);
    procedure mnuActionsPopup(Sender: TObject);
  private
    { Private declarations }
    histList: TStrings;
    procedure loadICEResults;
    procedure populateGrid(iceResults: TStrings);
    procedure addtoList(iceData: string);
    function getRecordType: string;
  public
    { Public declarations }
    constructor Create(aOwner: TComponent); override;
    procedure collapse;
  end;

var
  fraIce: TfraIce;

implementation

{$R *.dfm}

{ TfraIceImmunization }

procedure TfraIce.addImmunization(Sender: TObject);
var
recordType: string;
grid: TGridPanel;
aControl: TControl;
begin
  recordType := getRecordType;
  if recordType = '' then exit;
  grid := TGridPanel(self.Parent);
  aControl := grid.ControlCollection.Controls[0, 2];
  TfraVimmSelect(aControl).startFromIce(recordType);

end;

procedure TfraIce.addtoList(iceData: string);
var
 lstItem: TListItem;
 strs: TStrings;
 item: TStringList;
 temp: string;
begin
  item := TStringList.create;
  try
  lstice.Items.BeginUpdate;
  strs := TStringList.Create;
  temp := Piece(iceData, U, 2);
  if Piece(temp, ':', 1) = 'C' then
    strs.Add('CVX')
  else strs.Add('GROUP');
  strs.Add(Piece(iceData, U, 3));
  strs.Add(Piece(iceData, U, 8));
  if Piece(iceData, U, 4) <> '' then
    strs.Add(FormatFMDateTime('mm/dd/yyyy', StrToFloatDef(Piece(iceData, U, 4),0)));
  if Piece(iceData, u, 5) <> '' then
    strs.Add(FormatFMDateTime('mm/dd/yyyy', StrToFloatDef(Piece(iceData, U, 5),0)));
  lstItem := lstICE.Items.Add;
  lstItem.Caption := Piece(iceData, U, 2);
  lstItem.SubItems := strs;
  lstIce.Items.EndUpdate;
  finally
    FreeAndNil(item);
  end;
end;

procedure TfraIce.collapse;
begin
  if not fCollapsed then spbtnExpandCollapseClick(self);
end;

constructor TfraIce.Create(aOwner: TComponent);
begin
  inherited;
  HistList := TStringList.Create;
  loadICEResults;
end;

function TfraIce.getRecordType: string;
var
lstItem: TListItem;
idx: integer;
begin
  result := '';
  idx := lstICE.ItemIndex;
  if idx = -1 then
    begin
      ShowMessage('No row selected');
      exit;
    end;
  lstItem := lstICE.Items.Item[idx];
  result := lstItem.Caption;
  //name := lstItem.SubItems[0];
  //documType := lstItem.SubItems[1];
  //result := vid + U + name + U + documType;
end;

procedure TfraIce.loadICEResults;
var
iceResults: TStrings;
begin
  iceResults := TStringList.Create;
  try
    histList.Clear;
    getICEResults(iceResults);
    populateGrid(iceResults);
  finally
    FreeAndNil(iceResults);
  end;
end;

procedure TfraIce.mnuActionsPopup(Sender: TObject);
begin
  inherited;
      mnuActions.Items[1].Enabled := true;
      mnuActions.Items[1].Enabled := true;
end;

procedure TfraIce.populateGrid(iceResults: TStrings);
var
  dueNowList, conditionalList, notDueList: TStrings;
  temp,temp1,hist: string;
  i: integer;
begin
    dueNowList := TStringList.Create;
    conditionalList := TStringLIst.Create;
    notDueList := TStringList.Create;
    try
      for I := 0 to iceResults.Count-1 do
        begin
          temp := iceResults.Strings[i];
          if i = 0 then
            begin
              if Piece(temp, U, 1) = '-1' then
                begin
                  ShowMessage(Piece(temp, u, 2));
                  exit;
                end
                else continue;
            end;
//          temp1 := '';
          if Piece(temp, U, 1) = 'GRP' then
            begin
              temp1 := Pieces(temp, U, 2, 9);
              continue;
            end
          else if Piece(temp, u, 1) = 'RSN' then
            temp1 := temp1 + U + Pieces(temp, U, 2, 3)
          else if Piece(temp, u, 1) = 'HIST' then
            begin
              hist := Piece(temp, u, 4) + U + Piece(temp, u, 3) + ' ' +
              FormatFMDateTime('mm/dd/yyyy', StrToFloatDef(Piece(temp, u, 5),0));
              continue;
            end
          else temp1 := '';
          if Piece(temp1, U, 9) = 'DUE_NOW' then
            dueNowList.Add(temp1)
          else if Piece(temp1, U, 9) = 'HIGH_RISK' then
            conditionalList.Add(temp1)
          else if temp1 <> '' then notDueList.Add(temp1);
        end;
      if dueNowList.Count > -1 then
        begin
          for i := 0 to dueNowList.Count - 1 do
            addtoList(dueNowList.Strings[i]);
        end;

      if conditionalList.Count > -1 then
        begin
          for i := 0 to conditionalList.Count - 1 do
            addtoList(conditionalList.Strings[i]);
        end;

      if notDueList.Count > -1 then
        begin
          for i := 0 to notDueList.Count - 1 do
            addtoList(notDueList.Strings[i]);
        end;
    finally
      freeAndNil(dueNowList);
      freeAndNil(conditionalList);
      FreeAndNil(notDueList);
    end;
end;

procedure TfraIce.viewHistory(Sender: TObject);
var
recordType: string;
i: integer;
begin
  recordType := getRecordType;
  if recordType = '' then exit;
  for i := 0 to histList.Count - 1 do
    begin
      if Piece(histlist.Strings[i], u, 1) = Piece(recordType , ':', 2) then
        self.memHist.Lines.Add(Piece(histlist.Strings[i], u, 2));
    end;
end;

end.
